/*
 * Decompiled with CFR 0.152.
 */
package adql.db.exception;

import adql.parser.ParseException;
import adql.query.operand.ADQLColumn;

public class UnresolvedColumnException
extends ParseException {
    private static final long serialVersionUID = 1L;
    private final String columnName;

    public UnresolvedColumnException(ADQLColumn aDQLColumn) {
        super(UnresolvedColumnException.buildMessage("Unknown column", aDQLColumn));
        this.initPosition(aDQLColumn);
        this.columnName = aDQLColumn != null ? aDQLColumn.getColumnName() : null;
    }

    public UnresolvedColumnException(ADQLColumn aDQLColumn, String string, String string2) {
        super(UnresolvedColumnException.buildMessage("Ambiguous column name", aDQLColumn, string, string2));
        this.initPosition(aDQLColumn);
        this.columnName = aDQLColumn != null ? aDQLColumn.getColumnName() : null;
    }

    protected final void initPosition(ADQLColumn aDQLColumn) {
        this.position = aDQLColumn.getPosition();
    }

    public final String getColumnName() {
        return this.columnName;
    }

    private static final String buildMessage(String string, ADQLColumn aDQLColumn) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append(" \"").append(aDQLColumn.getFullColumnName()).append("\" !");
        return stringBuffer.toString();
    }

    private static final String buildMessage(String string, ADQLColumn aDQLColumn, String string2, String string3) {
        if (string2 != null && string3 != null) {
            StringBuffer stringBuffer = new StringBuffer(UnresolvedColumnException.buildMessage(string, aDQLColumn));
            stringBuffer.append(" It may be (at least) \"").append(string2).append("\" or \"").append(string3).append("\".");
            return stringBuffer.toString();
        }
        return UnresolvedColumnException.buildMessage(string, aDQLColumn);
    }
}

